<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode( file_get_contents( 'php://input' ), true );

// Iniciar la transacción
mysqli_autocommit( $conn, false );
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = '';

try {
    // Acceder a los valores individuales de los datos combinados
    $cEmpresa_Id = $data[ 'Empresa_id' ];
    $cDocFiscal_id = $data[ 'DocFiscal_Id' ];
    $cNSerie = $data[ 'NSerie' ];
    $cNDocumento = $data[ 'NDocumento' ];
    $cFechaEmision = $data[ 'Fecha_Emision' ];
    $cFechaTraslado = $data[ 'Fecha_Traslado' ];
    $cFechaVencimiento = $data[ 'Fecha_Vcto' ];
    $cNombre = $data[ 'Razon_Social' ];
    $cDireccion = $data[ 'Direccion' ];
    $cTipDocIdent = $data[ 'Tipo_Documento' ];
    $cDocIdentidad = $data[ 'DocIdentidad' ];
    $cNDias = $data[ 'NDias' ];
    $cMoneda = $data[ 'Moneda' ];
    $cTipoCambio = $data[ 'Tipo_Cambio' ];
    $cAfectoIgv = $data[ 'Afecto_IGV' ];
    $cP_Igv = $data[ 'pIGV' ];
    $cIgv = $data[ 'IGV' ];
    $cAfectDscto = $data[ 'Descuento' ];
    $cP_Dscto = $data[ 'pDSCTO' ];
    $cDescuento = $data[ 'Descuento' ];
    $cAfectoPercepcion = $data[ 'Afecto_Percepcion' ];
    $cP_Percepcion = $data[ 'pPercepcion' ];
    $cPercepcion = $data[ 'Percepcion' ];
    $cAfecto = $data[ 'Valor_Venta' ];
    $cInafecto = $data[ 'Inafecto' ];
    $cExonerado = $data[ 'Exonerada' ];
    $cTotal = $data[ 'Total_Pagar' ];
    $cGuiaRemision = $data[ 'NGuiaRemision' ];
    $cCancelado = $data[ 'Cancelado' ];
    $cIcbp = $data[ 'ICBPER' ];
    $cGratuitas = $data[ 'Gratuitas' ];
    $cAfectaKardex = $data[ 'Afecta_Kardex' ];
    $cAfectaCaja = $data[ 'Afecta_Caja' ];
    $cPeriodo = $data[ 'Periodo' ];
    $cMes = $data[ 'Mes' ];
    $cFormaPago_Id = $data[ 'Forma_Pago' ];
    $cCaja_Id = $data[ 'Caja_Id' ];
    $cCliente_Id = $data[ 'Cliente_Id' ];
    $cEmpleado_id = $data[ 'Empleado_Id' ];
    $cSucursal_Id = $data[ 'Sucursal_Id' ];
    $cObservacion = $data[ 'Observacion' ];
    $cAcuenta = $data[ 'a_Cuenta' ];
    //$cServicio = $data[ 'Servicio' ];
    //$cZona_Id = $data[ 'Zona_Id' ];
    $cMotivoNota = $data[ 'MotivoNota' ];
    $cDocFiscal_Ref = $data[ 'DocFiscal_Ref' ];
    $cNSerie_Ref = $data[ 'NSerie_Ref' ];
    $cNDocumento_Ref = $data[ 'Documento_Ref' ];
    $cFechaEmision_Ref = $data[ 'Fecha_EmisionRef' ];
    $iIdVta = $data[ 'IdVta_M' ];
    $cEstado = $data[ 'Estado' ];

    $cOperacion = ( $cDocFiscal_id == 5 ) ? 'NCC' : 'NDC';
    $cTipOperac = ( $cDocFiscal_id == 5 ) ? 'E' : 'I';

    if ( $cEstado == 'NUEVO' ) {

        // Ejemplo de inserción en la tabla productos
        $queryCabecera = "INSERT INTO ventas(empresa_id, docfiscal_id, nserie, ndocumento, fecha_emision, fecha_traslado, fecha_vencimiento, 
        razon_social, direccion, tipo_docidentidad, documento_identidad, nro_dias, moneda, tipo_cambio, afecto_igv, 
        porcentaje_igv, igv, afecto_dscto, porcentaje_dscto, descuento, afecto_percepcion, porcentaje_percepcion, percepcion,
        afecto, inafecto, exonerado, total, guia_remision, cancelado, icbp, gratuitas, afecta_kardex, afecta_caja, periodo, mes, 
        formapago_id, caja_id, cliente_id, empleado_id, sucursal_id, observacion, motivo_nota_id, 
        docfis_id_referencial, nserie_referencial, ndocumento_referencial, fecha_referencial)
        VALUES ('$cEmpresa_Id', '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cFechaVencimiento', 
        '$cNombre', '$cDireccion', '$cTipDocIdent', '$cDocIdentidad', '$cNDias', '$cMoneda', '$cTipoCambio', '$cAfectoIgv', '$cP_Igv', '$cIgv', 
        '$cAfectDscto', '$cP_Dscto', '$cDescuento', '$cAfectoPercepcion', '$cP_Percepcion', '$cPercepcion', '$cAfecto', '$cInafecto',
        '$cExonerado', '$cTotal', '$cGuiaRemision', '$cCancelado', '$cIcbp', '$cGratuitas', '$cAfectaKardex', '$cAfectaCaja', '$cPeriodo', '$cMes', 
        '$cFormaPago_Id', '$cCaja_Id', '$cCliente_Id', '$cEmpleado_id', '$cSucursal_Id', '$cObservacion', '$cMotivoNota',
        '$cDocFiscal_Ref', '$cNSerie_Ref', '$cNDocumento_Ref', '$cFechaEmision_Ref')";

        $resultadoCabecera = mysqli_query( $conn, $queryCabecera );
        if ( !$resultadoCabecera ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // Obtener el ID del último registro insertado en la cabecera de ventas
        $idVenta = mysqli_insert_id( $conn );

        // ACTUALIZA REGISTRO DE SERIES
        $query = "SELECT numero FROM series_sucursal WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
           AND nserie = '$cNSerie' FOR UPDATE";
        $result = mysqli_query( $conn, $query );
        if ( !$result ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        $queryUPD = "UPDATE series_sucursal SET numero = numero + 1 WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
          AND nserie = '$cNSerie'";
        $resultUPD = mysqli_query( $conn, $queryUPD );

        if ( !$resultUPD ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // REGISTRO DE VENTAS
        if ( $cDocFiscal_id == 5 ) {
            $queryReg_Ventas = "INSERT INTO registro_ventas(nserie, ndocumento, fecha_emision, fecha_vencimiento, tipo_docidentidad, documento_identidad,
                razon_social, afecto, exonerado, inafecto, igv, total, periodo, mes, moneda, tipo_cambio, docfiscal_id, 
                docfis_id_referencial, nserie_referencial, ndocumento_referencial, fecha_referencial, venta_id, empresa_id, sucursal_id)
                VALUES ('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cTipDocIdent', '$cDocIdentidad', '$cNombre',
                '$cAfecto'*-1, '$cExonerado'*-1, '$cInafecto'*-1, '$cIgv'*-1, '$cTotal'*-1, '$cPeriodo', '$cMes', '$cMoneda', '$cTipoCambio', '$cDocFiscal_id',
                '$cDocFiscal_Ref', '$cNSerie_Ref', '$cNDocumento_Ref', '$cFechaEmision_Ref', '$idVenta', '$cEmpresa_Id', '$cSucursal_Id')";
        } else {
            $queryReg_Ventas = "INSERT INTO registro_ventas(nserie, ndocumento, fecha_emision, fecha_vencimiento, tipo_docidentidad, documento_identidad,
                razon_social, afecto, exonerado, inafecto, igv, total, periodo, mes, moneda, tipo_cambio, docfiscal_id, 
                docfis_id_referencial, nserie_referencial, ndocumento_referencial, fecha_referencial, venta_id, empresa_id, sucursal_id)
                VALUES ('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cTipDocIdent', '$cDocIdentidad', '$cNombre',
                '$cAfecto', '$cExonerado', '$cInafecto', '$cIgv', '$cTotal', '$cPeriodo', '$cMes', '$cMoneda', '$cTipoCambio', '$cDocFiscal_id',
                '$cDocFiscal_Ref', '$cNSerie_Ref', '$cNDocumento_Ref', '$cFechaEmision_Ref', '$idVenta', '$cEmpresa_Id', '$cSucursal_Id')";
        }

        $resultadoReg_Ventas = mysqli_query( $conn, $queryReg_Ventas );
        if ( !$resultadoReg_Ventas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // CAJA
        if ( $cAfectaCaja == 1 ) {
            $queryCaja = "INSERT INTO detcaja(cuenta_id, tipo_movcaja, nrecibo, docfiscal_id, nserie, ndocumento, fecha_operacion,
                fecha_emision, egreso, partida_id, nombre_partida, moneda, tipo_cambio, movimiento_id, operacion, 
                observacion, offsystem, empresa_id, sucursal_id)
                VALUES('$cCaja_Id', '$cTipOperac', CONCAT('$cNSerie','-','$cNDocumento'), '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision',
                '$cFechaEmision', '$cTotal', '$cCliente_Id', '$cNombre', '$cMoneda', '$cTipoCambio', '$idVenta', '$cOperacion', '$cObservacion', '1', '$cEmpresa_Id',
                '$cSucursal_Id')";

            $resultadoCaja = mysqli_query( $conn, $queryCaja );
            if ( !$resultadoCaja ) {
                throw new Exception( mysqli_error( $conn ) );
            }

        }
        ;

        // Ejemplo de inserción en la tabla detalle
        foreach ( $data[ 'detalle' ] as $detalle_ ) {
            $cAlmacen_Id = $detalle_[ 'almacen_id' ];
            $cProducto_Id = $detalle_[ 'producto_id' ];
            $cBonificdProd = $detalle_[ 'bonificacion' ];
            $cCodProd = $detalle_[ 'codigo_producto' ];
            $cCantidad = $detalle_[ 'cantidad' ];
            $cRecogido = $detalle_[ 'recogido' ];
            $cCapacidad_Precio = $detalle_[ 'capacidad_precio' ];
            $cDescrip_Precio = $detalle_[ 'descrip_precio' ];
            $cPrecio_Bruto = $detalle_[ 'precio_bruto' ];
            $cDescuento = $detalle_[ 'descuento' ];
            $cPrecio = $detalle_[ 'precio' ];
            $cPrecioigv = $detalle_[ 'precioigv' ];
            $cIgv = $detalle_[ 'igv' ];
            $cPercepcion = $detalle_[ 'percepcion' ];
            $cAfecto = $detalle_[ 'afecto' ];
            $cInafecto = $detalle_[ 'inafecto' ];
            $cExonerado = $detalle_[ 'exonerado' ];
            $cSubtotal = $detalle_[ 'subtotal' ];
            $cSubtotaligv = $detalle_[ 'subtotaligv' ];
            $cMargen = $detalle_[ 'margen' ];
            $cCosto = $detalle_[ 'costo' ];
            $cPeso = $detalle_[ 'peso' ];
            $cPorcentaje_Igv = $detalle_[ 'porcentaje_igv' ];
            $cIcbp = $detalle_[ 'icbp' ];
            $cDescripcion_Servicio = $detalle_[ 'descripcion_servicio' ];
            $cVencimiento = $detalle_[ 'vencimiento' ];
            $cLote = $detalle_[ 'lote' ];
            $cAbrev_Universal = $detalle_[ 'abrev_universal' ];
            $cRazon_Social = $cNombre;
            $cObservacion = $cObservacion;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_[ 'categoria_id' ];
            $cMarca_Id = $detalle_[ 'marca_id' ];
            $cModelo_Id = $detalle_[ 'modelo_id' ];

            $queryDetalle = "INSERT INTO detventas (venta_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id,
            bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
            precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, margen, costo, peso, 
            porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id, modelo_id,
            empresa_id, sucursal_id) 
            VALUES ('$idVenta', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cAlmacen_Id', '$cProducto_Id', 
            '$cBonificdProd', '$cCodProd', '$cCantidad', '$cRecogido', '$cCapacidad_Precio', '$cDescrip_Precio', '$cPrecio_Bruto', '$cDescuento', '$cPrecio', 
            '$cPrecioigv', '$cIgv', '$cPercepcion', '$cAfecto', '$cInafecto', '$cExonerado', '$cSubtotal', '$cSubtotaligv', '$cMargen', '$cCosto', '$cPeso', 
            '$cPorcentaje_Igv', '$cIcbp', '$cDescripcion_Servicio', '$cVencimiento', '$cLote', '$cAbrev_Universal', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
            '$cModelo_Id', '$cEmpresa_Id', '$cSucursal_Id')";
            $resultadoDetalle = mysqli_query( $conn, $queryDetalle );

            if ( !$resultadoDetalle ) {
                throw new Exception( mysqli_error( $conn ) );
            }

            //KARDEX
            if ( $cAfectaKardex == 1 ) {
                $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cOperacion', '$cProducto_Id', '$cCodProd', ('$cCantidad'*'$cCapacidad_Precio'), '$cPrecioigv',
                0, 0, ('$cRecogido'*'$cCapacidad_Precio'), '$cVencimiento', '$cLote', 0, '$cNombre', '$cObservacion', 
                '$cDescrip_Precio', '$cEmpresa_Id', '$cSucursal_Id', '$cAlmacen_Id', 0, '$idVenta', '$cCapacidad_Precio', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
                '$cModelo_Id')";
                $resultadoKardex = mysqli_query( $conn, $queryKardex );

                if ( !$resultadoKardex ) {
                    throw new Exception( mysqli_error( $conn ) );
                }

            }
            ;

        }

        // Ejemplo de inserción en la tabla cuotas
        foreach ( $data[ 'cuotas' ] as $cuota ) {
            $cVenta_Id = $idVenta;
            // Usar el mismo Id_Venta generado
            $cNroCuota = $cuota[ 'numero_cuota' ];
            $cImporte = $cuota[ 'importe' ];
            //
            $cFechaPago = $cuota[ 'fecha_pago' ];
            $cCliente_Id = $cuota[ 'cliente_id' ];
            //$cEmpresa_Id = $cuota[ 'Empresa_id' ];
            //$cSucursal_Id = $cuota[ 'Sucursal_id' ];
            //

            $queryCuotas = "INSERT INTO cuotasclientes(venta_id, numero_cuota, importe, fecha_pago, cliente_id, empresa_id, sucursal_id)
            VALUES('$cVenta_Id', '$cNroCuota', '$cImporte', '$cFechaPago', '$cCliente_Id', '$cEmpresa_Id', '$cSucursal_Id')";

            $resultadoCuotas = mysqli_query( $conn, $queryCuotas );

            if ( !$resultadoCuotas ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }

        /*// Ejemplo de inserción en la tabla series
        foreach ( $series as $serie ) {
            $cVenta_Id = $idVenta;
            $cSerie = $serie[ 'Serie' ];
            $cOperacion = $serie[ 'Operacion' ];
            $cIdProducto = $serie[ 'Producto_id' ];

            $querySerieProducto = "UPDATE kardex_serieprod SET movimiento_id = '$cVenta_Id', operacion = '$cOperacion', IUD = ''
                    WHERE producto_id = '$cIdProducto' AND serie = '$cSerie'";
            $resultadoSerieProducto = mysqli_query( $conn, $querySerieProducto );

            if ( !$resultadoSerieProducto ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }
        */

    } elseif ( $cEstado == 'MODIFICAR' ) {

        $queryUpd_DetVtas = "UPDATE detventas SET IUD = 'D' WHERE venta_id = $iIdVta";
        $resultadoUpd_DetVtas = mysqli_query( $conn, $queryUpd_DetVtas );

        if ( !$resultadoUpd_DetVtas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        $queryUpd_Kardex = "UPDATE kardex SET IUD = 'D' WHERE venta_id = $iIdVta";
        $resultadoUpd_Kardex = mysqli_query( $conn, $queryUpd_Kardex );

        if ( !$resultadoUpd_Kardex ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        $queryUpd_Cuotas = "UPDATE cuotasclientes SET IUD = 'D' WHERE venta_id = $iIdVta";
        $resultadoUpd_Cuotas = mysqli_query( $conn, $queryUpd_Cuotas );

        if ( !$resultadoUpd_Cuotas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        /*$queryUpd_Kardex_Serie = "UPDATE kardex_serieprod SET IUD = 'D' WHERE movimiento_id = $iIdVta AND operacion = 'VTA'";
        $resultadoUpd_Kardex_Serie = mysqli_query( $conn, $queryUpd_Kardex_Serie );

        if ( !$resultadoUpd_Kardex_Serie ) {
            throw new Exception( mysqli_error( $conn ) );
        }
        */

        $queryUpd_Ventas = "UPDATE ventas SET empresa_id = '$cEmpresa_Id', docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
             fecha_emision = '$cFechaEmision', fecha_traslado = '$cFechaTraslado', fecha_vencimiento = '$cFechaVencimiento', razon_social = '$cNombre',
             direccion = '$cDireccion', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad', nro_dias = '$cNDias', 
             moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', afecto_igv = '$cAfectoIgv', porcentaje_igv = '$cP_Igv', igv = '$cIgv', 
             afecto_dscto = '$cAfectDscto', porcentaje_dscto = '$cP_Dscto', descuento = '$cDescuento', afecto_percepcion = '$cAfectoPercepcion', 
             porcentaje_percepcion = '$cP_Percepcion', percepcion = $cPercepcion, afecto = '$cAfecto', inafecto = '$cInafecto', exonerado = '$cExonerado',
             total = '$cTotal', guia_remision = '$cGuiaRemision', cancelado = '$cCancelado', icbp = '$cIcbp', gratuitas = '$cGratuitas', 
             afecta_kardex = '$cAfectaKardex', afecta_caja = $cAfectaCaja, periodo = '$cPeriodo', mes = '$cMes', formapago_id = '$cFormaPago_Id',
             caja_id = '$cCaja_Id', cliente_id = '$cCliente_Id', empleado_id = '$cEmpleado_id', sucursal_id = '$cSucursal_Id', observacion = '$cObservacion',
             motivo_nota_id = '$cMotivoNota', docfis_id_referencial = '$cDocFiscal_Ref', nserie_referencial = '$cNSerie_Ref', 
             ndocumento_referencial = '$cNDocumento_Ref', fecha_referencial = '$cFechaEmision_Ref'
           WHERE id = $iIdVta";

        $resultadoUpd_Ventas = mysqli_query( $conn, $queryUpd_Ventas );

        if ( !$resultadoUpd_Ventas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // REGISTRO DE VENTAS
        if ( $cDocFiscal_id = 5 ) {
            $queryUpd_RegVtas = "UPDATE registro_ventas SET nserie = '$cNSerie', ndocumento = '$cNDocumento', fecha_emision = '$cFechaEmision', 
               fecha_vencimiento = '$cFechaVencimiento', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad',
               razon_social = '$cNombre', afecto = '$cAfecto'*-1, exonerado = '$cExonerado'*-1, inafecto = '$cInafecto'*-1, igv = '$cIgv'*-1, total = '$cTotal'*-1, 
               periodo = '$cPeriodo', mes = '$cMes', moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', docfiscal_id = '$cDocFiscal_id',
               docfis_id_referencial = '$cDocFiscal_Ref', nserie_referencial = '$cNSerie_Ref', ndocumento_referencial = '$cNDocumento_Ref', 
               fecha_referencial = '$cFechaEmision_Ref' WHERE venta_id = $iIdVta";
        } else {

            $queryUpd_RegVtas = "UPDATE registro_ventas SET nserie = '$cNSerie', ndocumento = '$cNDocumento', fecha_emision = '$cFechaEmision', 
               fecha_vencimiento = '$cFechaVencimiento', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad',
               razon_social = '$cNombre', afecto = '$cAfecto', exonerado = '$cExonerado', inafecto = '$cInafecto', igv = '$cIgv', total = '$cTotal', 
               periodo = '$cPeriodo', mes = '$cMes', moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', docfiscal_id = '$cDocFiscal_id',
               docfis_id_referencial = '$cDocFiscal_Ref', nserie_referencial = '$cNSerie_Ref', ndocumento_referencial = '$cNDocumento_Ref', 
               fecha_referencial = '$cFechaEmision_Ref' WHERE venta_id = $iIdVta";
        }

        $resultadoUpd_RegVtas = mysqli_query( $conn, $queryUpd_RegVtas );

        if ( !$resultadoUpd_RegVtas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // CAJA
        if ( $cAfectaCaja == 1 ) {
            $queryCount = "SELECT COUNT(id) FROM detcaja WHERE movimiento_id = $iIdVta AND operacion = '$cOperacion'";
            $result = mysqli_query( $conn, $queryCount );
            // Suponiendo que has establecido una conexión a la base de datos ( $conexion )
            if ( !$result ) {
                // Manejo de error si la consulta falla
                die( 'Error al ejecutar la consulta: ' . mysqli_error( $conn ) );
            }

            $row = mysqli_fetch_array( $result );
            $count = $row[ 0 ];
            if ( $count == 0 ) {
                $queryUpd_DetCaja = "INSERT INTO detcaja(cuenta_id, tipo_movcaja, nrecibo, docfiscal_id, nserie, ndocumento, fecha_operacion,
                 fecha_emision, ingreso, partida_id, nombre_partida, moneda, tipo_cambio, movimiento_id, operacion, 
                 observacion, offsystem, empresa_id, sucursal_id)
               VALUES('$cCaja_Id', '$cTipOpera', CONCAT('$cNSerie','-','$cNDocumento'), '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision',
                 '$cFechaEmision', '$cTotal', '$cCliente_Id', '$cNombre', '$cMoneda', '$cTipoCambio', '$iIdVta', '$cOperacion', '$cObservacion', 1, '$cEmpresa_Id',
                 '$cSucursal_Id')";
            } else {
                $queryUpd_DetCaja = "UPDATE detcaja SET cuenta_id = '$cCaja_Id', tipo_movcaja = '$cTipOpera', nrecibo = CONCAT('$cNSerie','-','$cNDocumento'),
                 fecha_operacion = '$cFechaEmision', docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
                 fecha_emision = '$cFechaEmision', ingreso = '$cTotal', partida_id = '$cCliente_Id', nombre_partida = '$cNombre', 
                 moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', observacion = '$cObservacion' WHERE movimiento_id = $iIdVta AND operacion = '$cOperacion'";
            }
            $resultUpdate = mysqli_query( $conn, $queryUpd_DetCaja );
            if ( !$resultUpdate ) {
                // Manejo de error si la actualización falla
                die( 'Error al ejecutar la actualización: ' . mysqli_error( $conn ) );
            }

        }
        ;

        // Ejemplo de inserción en la tabla detalle
        foreach ( $data[ 'detalle' ] as $detalle_ ) {
            //$cVenta_Id = $idVenta;
            //$cNSerie = $detalle_[ 'Nserie' ];
            //$cNDocumento = $detalle_[ 'Ndocumento' ];
            //$cFechaEmision = $detalle_[ 'Fecha_emision' ];
            //$cFechaTraslado = $detalle_[ 'Fecha_traslado' ];
            //$cOperacion = 'VTA';
            $cAlmacen_Id = $detalle_[ 'almacen_id' ];
            $cProducto_Id = $detalle_[ 'producto_id' ];
            $cBonificdProd = $detalle_[ 'bonificacion' ];
            $cCodProd = $detalle_[ 'codigo_producto' ];
            $cCantidad = $detalle_[ 'cantidad' ];
            $cRecogido = $detalle_[ 'recogido' ];
            $cCapacidad_Precio = $detalle_[ 'capacidad_precio' ];
            $cDescrip_Precio = $detalle_[ 'descrip_precio' ];
            $cPrecio_Bruto = $detalle_[ 'precio_bruto' ];
            $cDescuento = $detalle_[ 'descuento' ];
            $cPrecio = $detalle_[ 'precio' ];
            $cPrecioigv = $detalle_[ 'precioigv' ];
            $cIgv = $detalle_[ 'igv' ];
            $cPercepcion = $detalle_[ 'percepcion' ];
            $cAfecto = $detalle_[ 'afecto' ];
            $cInafecto = $detalle_[ 'inafecto' ];
            $cExonerado = $detalle_[ 'exonerado' ];
            $cSubtotal = $detalle_[ 'subtotal' ];
            $cSubtotaligv = $detalle_[ 'subtotaligv' ];
            $cMargen = $detalle_[ 'margen' ];
            $cCosto = $detalle_[ 'costo' ];
            $cPeso = $detalle_[ 'peso' ];
            $cPorcentaje_Igv = $detalle_[ 'porcentaje_igv' ];
            $cIcbp = $detalle_[ 'icbp' ];
            $cDescripcion_Servicio = $detalle_[ 'descripcion_servicio' ];
            $cVencimiento = $detalle_[ 'vencimiento' ];
            $cLote = $detalle_[ 'lote' ];
            $cAbrev_Universal = $detalle_[ 'abrev_universal' ];
            $cRazon_Social = $cNombre;
            $cObservacion = $cObservacion;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_[ 'categoria_id' ];
            $cMarca_Id = $detalle_[ 'marca_id' ];
            $cModelo_Id = $detalle_[ 'modelo_id' ];
            //$cEmpresa_Id = $detalle_[ 'Empresa_id' ];
            //$cSucursal_Id = $detalle_[ 'Sucursal_id' ];

            $queryDetalle = "INSERT INTO detventas (venta_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id,
             bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
             precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, margen, costo, peso, 
             porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id,
             modelo_id, empresa_id, sucursal_id) 
            VALUES ('$iIdVta', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cAlmacen_Id', '$cProducto_Id', 
            '$cBonificdProd', '$cCodProd', '$cCantidad', '$cRecogido', '$cCapacidad_Precio', '$cDescrip_Precio', '$cPrecio_Bruto', '$cDescuento', '$cPrecio', 
            '$cPrecioigv', '$cIgv', '$cPercepcion', '$cAfecto', '$cInafecto', '$cExonerado', '$cSubtotal', '$cSubtotaligv', '$cMargen', '$cCosto', '$cPeso', 
            '$cPorcentaje_Igv', '$cIcbp', '$cDescripcion_Servicio', '$cVencimiento', '$cLote', '$cAbrev_Universal', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
            '$cModelo_Id', '$cEmpresa_Id', '$cSucursal_Id')";
            $resultadoDetalle = mysqli_query( $conn, $queryDetalle );

            if ( !$resultadoDetalle ) {
                throw new Exception( mysqli_error( $conn ) );
            }

            //KARDEX
            if ( $cAfectaKardex == 1 ) {
                $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cOperacion', '$cProducto_Id', '$cCodProd', ('$cCantidad'*'$cCapacidad_Precio'), '$cPrecioigv',
                0, 0, ('$cRecogido'*'$cCapacidad_Precio'), '$cVencimiento', '$cLote', 0, '$cNombre', '$cObservacion', 
                '$cDescrip_Precio', '$cEmpresa_Id', '$cSucursal_Id', '$cAlmacen_Id', 0, '$iIdVta', '$cCapacidad_Precio', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
                '$cModelo_Id')";
                $resultadoKardex = mysqli_query( $conn, $queryKardex );

                if ( !$resultadoKardex ) {
                    throw new Exception( mysqli_error( $conn ) );
                }

            };

        }

        // Ejemplo de inserción en la tabla cuotas
        foreach ( $data[ 'cuotas' ] as $cuota ) {
            $cVenta_Id = $iIdVta;
            // Usar el mismo Id_Venta generado
            $cNroCuota = $cuota[ 'numero_cuota' ];
            $cImporte = $cuota[ 'importe' ];
            //
            $cFechaPago = $cuota[ 'fecha_pago' ];
            $cCliente_Id = $cuota[ 'cliente_id' ];
            //$cEmpresa_Id = $cuota[ 'Empresa_id' ];
            //$cSucursal_Id = $cuota[ 'Sucursal_id' ];

            $queryCuotas = "INSERT INTO cuotasclientes(venta_id, numero_cuota, importe, fecha_pago, cliente_id, empresa_id, sucursal_id)
            VALUES('$cVenta_Id', '$cNroCuota', '$cImporte', '$cFechaPago', '$cCliente_Id', '$cEmpresa_Id', '$cSucursal_Id')";

            $resultadoCuotas = mysqli_query( $conn, $queryCuotas );

            if ( !$resultadoCuotas ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }

        /*// Ejemplo de inserción en la tabla series
        foreach ( $series as $serie ) {
            $cVenta_Id = $iIdVta;
            $cSerie = $serie[ 'Serie' ];
            $cOperacion = $serie[ 'Operacion' ];
            $cIdProducto = $serie[ 'Producto_id' ];

            $querySerieProducto = "UPDATE kardex_serieprod SET movimiento_id = '$cVenta_Id', operacion = '$cOperacion', IUD = ''
                    WHERE producto_id = '$cIdProducto' AND serie = '$cSerie'";
            $resultadoSerieProducto = mysqli_query( $conn, $querySerieProducto );

            if ( !$resultadoSerieProducto ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }
        */

        //Elimina Detalle de Venta para Evitar la Duplicidad
        $queryDelVtas = "DELETE FROM detventas WHERE venta_id = $iIdVta AND IUD = 'D'";
        $resultadoDelVtas = mysqli_query( $conn, $queryDelVtas );

        if ( !$resultadoDelVtas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        //Elimina Kardex para Evitar la Duplicidad
        $queryDelKardex = "DELETE FROM kardex WHERE venta_id = $iIdVta AND IUD = 'D'";
        $resultadoDelKardex = mysqli_query( $conn, $queryDelKardex );

        if ( !$resultadoDelKardex ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        //Elimina Cuotas del Cliente para Evitar la Duplicidad
        $queryDelCuotas = "DELETE FROM cuotasclientes WHERE venta_id = $iIdVta AND IUD = 'D'";
        $resultadoDelCuotas = mysqli_query( $conn, $queryDelCuotas );

        if ( !$resultadoDelCuotas ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        //Elimina Kardex Serie para Evitar la Duplicidad
        /*$queryDelKardexSerie = "DELETE FROM kardex_serieprod WHERE movimiento_id = $iIdVta AND operacion = 'VTA' AND IUD = 'D'";
        $resultadoDelKardexSerie = mysqli_query( $conn, $queryDelKardexSerie );

        if ( !$resultadoDelKardexSerie ) {
            throw new Exception( mysqli_error( $conn ) );
        }
        */

    }

    // Confirmar la transacción
    mysqli_commit( $conn );

} catch ( Exception $e ) {
    // Revertir la transacción en caso de error
    mysqli_rollback( $conn );
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close( $conn );

// Enviar una respuesta al cliente
if ( $transaccionExitosa ) {
    $response = array();
    //$response = array( 'ESTADO' => '00', 'MENSAJE' => 'Los datos se han guardado correctamente' );
    if ( $cEstado == 'NUEVO' ) {
        if ( $idVenta > 0 ) {
            //$response = array();
            $response[ 'ESTADO' ] = '00';
            $response[ 'ID' ] = $idVenta;
            $response[ 'MENSAJE' ] = 'Los datos se han guardado correctamente';
        } else {
            //$response = array();
            $response[ 'ESTADO' ] = '11';
            $response[ 'ID' ] = 0;
            $response[ 'MENSAJE' ] = 'Error al guardar la información: ' . $errorMensaje;
        }
    } else {
        //$response = array();
        $response[ 'ESTADO' ] = '00';
        $response[ 'ID' ] = $iIdVta;
        $response[ 'MENSAJE' ] = 'Los datos se actualizaron correctamente';
    }
} else {
    //$response = array( 'ESTADO' => '11', 'MENSAJE' => 'Error al guardar la información: ' . $errorMensaje );
    $response = array();
    $response[ 'ESTADO' ] = '111';
    $response[ 'ID' ] = 0;
    $response[ 'MENSAJE' ] = 'Error al guardar la información: ' . $errorMensaje;
}
echo json_encode( $response );

?>
